# Procreation Plus

## Rewarding your breeding efforts in Valheim!
This mod is a very simple expansion to the taming and breeding system in Valheim. It allows each tamable creature (Boar, Lox, Wolf, Hen, Asksvin) to have a configurable chance of giving birth to a higher level offspring. Everything is configurable and gives you many options to tailor to your liking, including adjusting other breedable creatures introduced by other mods!

Why would this mod be useful?
- You won't need to spend so much time trying to track down a 1 or 2 star creature.
- When setting up a new base, you won't need to transport high level creatures from your first base to your new base if you wanted to relocate permanently. You could find some lower level ones and just breed up again.
- You can make breeding more rewarding by making higher level creatures possible, e.g. a 2 star Lox you could only ever get from breeding and that is not found in the wild.
- In the event your base got trashed and you lost your valuable 2 star creatures, all is not lost as you can work your way back up.

Since IronGate updated some of their Procreation coding to work with Asksvin, this mod now works with those and chickens automatically!

## Supported Creatures
Currently this mod supports the following creatures by default, and you can change these values, and add your own creatures that are already breedable from other mods (see Configuration section for details):

- **Boar**: Can reach up to 2 stars when breeding. Offspring have a 25% chance to level up.
- **Wolf**: Can reach up to 2 stars when breeding. Offspring have a 10% chance to level up.
- **Lox**: Can reach up to 2 star when breeding. Offspring have a 5% chance to level up.
- **Hen**: Can reach up to 2 stars when laying an egg. Egg has a 5% chance to be one level higher than the hen who laid it.
- **Asksvin**: Can reach up to 2 stars when laying an egg. Egg has a 5% chance to be one level higher than the asksvin who laid it.

## Configuration
All of the configuration can be found in `maxfoxgaming.procreationplus.yml`, which will be generated once you start Valheim with the mod installed. Here's a snippet of the YML:

```yml
- PrefabName: Boar
  LevelUpChance: 0.25
  MaxStars: 2
```

- `PrefabName`: The ID, or name of the creature's prefab - it is *case-sensitive* so be sure to verify the prefab name. **Localized names will not work**. If you're unsure of prefab names, you can check the Valheim Wiki, or look at other mods' wiki entries which will usually list their prefabs.
- `LevelUpChance`: This is a value that should be set between 0 and 1, denoting the probability that a creature will be a level higher than the parent when it's born. A value of 0 means levelup will never happen, and a value of 1 will always result in a levelup. 0.5 is a 50% chance.
- `MaxStars`: A value between 0 and 2. If **Creature Level & Loot Control** is also installed, this value can be set up to 5. This denotes the highest level a creature can reach through breeding.

Note that adding creatures that are not currently tamable or breedable **does NOT give the creature the ability to be tamed or bred**. It only affects creatures that already have the Procreation script attached to them, whether vanilla or modded. 

If you want to make a creature breedable, you'll need another mod to do that such as **AllTameableTamingOverhaul** or **MonsterDB**, as this mod will not cover adding extra scripts to creatures for now or making baby creatures of currently existing ones.

### Adding more creatures ###

You can add as many creatures as you want to the YML. All you need is:
- The ID, or prefab name of the creature you want to add
- Ensure the creature has a Procreation component. Most mod authors will be able to tell you whether this is the case, but you can also install a mod like **UnityExplorer**, spawn the creature in with commands, and check its components manually.
- (Optional) If you want your creatures to breed higher than 2 stars, make sure **Creature Level & Loot Control** is installed and active in your mod list.

Let's look at the Fox from Therzie's Monstrum mod and add it to the list. Its prefab ID is `Fox_TW` and it can breed, so the Procreation component is present. Now we just add the YML entry below the others like this:

```yml
- PrefabName: Fox_TW
  LevelUpChance: 0.3
  MaxStars: 2
```

This will give all tamed foxes a 30% chance to give birth to fox cub with a higher level than its parents, up to 2 stars.

## Compatibility

This mod is fully compatible with:
- **Smoothbrain Creature Level & Loot Control**
- **Meldurson AllTameableTamingOverhaul**
- **RustyMods MonsterDB**
- **Therzie Monstrum & MonstrumDeepNorth**
- **Soloredis RTD Mods**
- **Horem FarmyardAnimals**
- **Yggdrah DragonRiders**
- **Blacks7ar TameableNeck**
- and most other mods that add creatures and animals.

This mod may have issues with
- **Blacks7ar TameableLeech**: Not tested whether bloodbag drop is affected. Should't cause any major issues, but I will add extra compatibility to it if needed.

## Contact Me (Bug Reports & Suggestions)
If you have any suggestions, or experience bugs / problems using this mod please get in touch with me on my [Discord](https://discord.gg/PY3hdKgvHJ).

## Installation (Manual Download)
Move the 'plugins' folder from the archive to your BepInEx folder.